﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class Forms
    '管理文档窗体列表的内部集合。
    '“About”（关于）这样的窗体将不在
    '此列表中，只有作为“document”（文档）屏幕的 frmMain 在此列表中。
    Private Shared m_Forms As New Collection()
    '为每个新窗体创建默认标题时使用的
    '内部计数器
    Private Shared m_FormsCreated As Integer = 0
    '此属性用于确定
    '在用户单击
    '具有已更新内容的窗体显示的“Save”（保存）文档对话框上的“Cancel”（取消）按钮时
    '是否需要停止应用程序关闭操作。
    Private Shared m_CancelExit As Boolean = False
    '用于检查是否正在关闭
    Private Shared m_ShutdownInProgress As Boolean = False

    '当前加载的窗体数
    Public Shared ReadOnly Property Count() As Integer
        Get
            Return m_Forms.Count
        End Get
    End Property

    Public Shared Sub Main()
        '打开第一个文档窗口
        Try
            Forms.NewForm()
        Catch exp As Exception
            '如果运行到此处，则表示出现了问题。
            MessageBox.Show("Sorry, we were unable to load a document. Good Bye.", "Application Main", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Application.Exit()
        End Try

        '设置主线程在
        '特定窗体的控件以外运行，这样，关闭一个文档
        '就不会终止整个进程。
        Application.Run()
    End Sub

    Public Shared Sub NewForm()
        Try
            Forms.m_FormsCreated += 1
            Dim frm As New MainForm()
            frm.Text = "Document" & Forms.m_FormsCreated.ToString()
            m_Forms.Add(frm, frm.GetHashCode.ToString())
            '挂钩新窗体的 Closed 事件，以便了解何时
            '关闭文档窗口
            AddHandler frm.Closed, AddressOf Forms.frmMain_Closed
            '挂钩自定义 SaveWhileClosingCancelled，以便了解
            '用户在得到保存已更新文档的提示时是否单击“Cancel”（取消）按钮。
            AddHandler frm.SaveWhileClosingCancelled, AddressOf Forms.frmMain_SaveWhileClosingCancelled
            '挂钩自定义 ExitApplicaiton，以便了解用户是否
            '通过从文档窗体选择“Exit”（退出）菜单项来关闭应用程序。
            AddHandler frm.ExitApplication, AddressOf Forms.frmMain_ExitApplication

            '使窗体可见
            frm.Show()

        Catch exp As Exception
            MessageBox.Show(exp.Message, exp.Source, MessageBoxButtons.OK, MessageBoxIcon.Error)
            If Forms.Count = 0 Then
                '将错误重新引发到 Main，以便
                '能够关闭进程
                Throw exp
            End If
        End Try
    End Sub

    Private Shared Sub FormClosed(ByVal frm As MainForm)
        '从内部集合删除已关闭的窗体。
        m_Forms.Remove(frm.GetHashCode.ToString())

        '如果不再有其他窗体，则关闭进程。
        If m_Forms.Count = 0 Then
            Application.Exit()
        End If
    End Sub

    Public Shared Sub ExitApp()
        Try
            m_ShutdownInProgress = True

            '在所有窗体关闭后关闭。
            Dim frm As MainForm
            Dim i As Integer

            '以一次向后步进一个窗体的方式
            '在集合中循环，要求每个窗体自行关闭。
            '只要求已更新的窗体采用这种方式。
            '如果用户选择“Cancel”（取消），我们不会关闭打开的窗体。
            For i = m_Forms.Count To 1 Step -1
                frm = CType(m_Forms(i), MainForm)
                If frm.Dirty Then
                    frm.Close()
                End If

                '检查内部标志，以确定
                '用户是否希望停止关闭操作。
                If m_CancelExit = True Then
                    m_CancelExit = False
                    Exit Sub
                End If
            Next

            '现在，关闭所有未更新的文档。
            '此时任何其他窗口都无法取消
            '关闭操作。
            If m_Forms.Count > 0 Then
                For i = m_Forms.Count To 1 Step -1
                    frm = CType(m_Forms(i), MainForm)
                    frm.Close()
                Next
            End If
        Catch exp As Exception
            MessageBox.Show(exp.Message, exp.Source, MessageBoxButtons.OK, MessageBoxIcon.Error)
            '如果此处发现错误则退出
            Application.Exit()
        Finally
            m_ShutdownInProgress = False
        End Try
    End Sub

    Private Shared Sub frmMain_Closed(ByVal sender As Object, ByVal e As System.EventArgs)
        Try
            '在窗体关闭以后，我们将捕获此事件。
            Dim frm As MainForm = CType(sender, MainForm)

            '移除创建窗体时添加的事件处理程序。
            RemoveHandler frm.Closed, AddressOf Forms.frmMain_Closed
            RemoveHandler frm.SaveWhileClosingCancelled, AddressOf Forms.frmMain_SaveWhileClosingCancelled
            RemoveHandler frm.ExitApplication, AddressOf Forms.frmMain_ExitApplication

            '调用函数以进行清理
            Forms.FormClosed(frm)
        Catch exp As Exception
            MessageBox.Show(exp.Message, exp.Source, MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try

    End Sub

    Private Shared Sub frmMain_SaveWhileClosingCancelled(ByVal sender As Object, ByVal e As System.EventArgs)
        '如果用户在收到保存已更新文档的要求时单击“Cancel”（取消），
        '则捕获此事件。
        If m_ShutdownInProgress Then
            '如果实际正处于关闭过程中，则
            '仅更改内部值。
            Forms.m_CancelExit = True
        End If

    End Sub

    Private Shared Sub frmMain_ExitApplication(ByVal sender As Object, ByVal e As System.EventArgs)
        '如果用户单击“Exit”（退出）菜单命令，则
        '将捕获此事件。
        Forms.ExitApp()
    End Sub


End Class
